% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shotchart.R
\name{shotchart}
\alias{shotchart}
\title{Plots different kinds of charts based on shot coordinates}
\usage{
shotchart(
  data,
  x,
  y,
  z = NULL,
  z.fun = median,
  result = NULL,
  type = NULL,
  scatter = FALSE,
  num.sect = 7,
  n = 1000,
  col.limits = c(NA, NA),
  courtline.col = "black",
  bg.col = "white",
  sectline.col = "white",
  text.col = "white",
  legend = FALSE,
  drop.levels = TRUE,
  pt.col = "black",
  pt.alpha = 0.5,
  nbins = 25,
  palette = "mixed"
)
}
\arguments{
\item{data}{A data frame whose rows are field shots and columns are half-court shot coordinates x and y, and optionally additional variables to be specified in \code{z} and/or \code{result} (see Details).}

\item{x}{character, indicating the variable name of the x coordinate.}

\item{y}{character, indicating the variable name of the y coordinate.}

\item{z}{character, indicating the name of the variable used to color the points (if \code{type=NULL}) or the sectors (if \code{type="sectors"}, in this case \code{z} must be a numeric variable).}

\item{z.fun}{function (active when \code{type="sectors"}), used to summarize the values of \code{z} variable within each sector (recommended: \code{mean}, \code{median}).}

\item{result}{character (active when \code{type="sectors"} and \code{scatter=FALSE}), indicating the name of the factor with the shot result (allowed categories \code{made} and \code{missed}).}

\item{type}{character, indicating the plot type; available option are \code{NULL}, \code{"sectors"}, \code{"density-polygons"}, \code{"density-raster"}, \code{"density-hexbin"}.}

\item{scatter}{logical, if TRUE a scatter plot of the shots is added to the plot.}

\item{num.sect}{integer (active when \code{type="sectors"}), number of sectors.}

\item{n}{integer (active when \code{type="sectors"}), number of points used to draw arcs (must be > 500).}

\item{col.limits}{numeric vector, (active  when \code{z} is a numeric variable), limits \code{c(min, max)} for the gradient color scale of \code{z} variable.}

\item{courtline.col}{color of court lines.}

\item{bg.col}{background color.}

\item{sectline.col}{color of sector lines (active when \code{type="sectors"}).}

\item{text.col}{color of text annotation within sectors (active when \code{type="sectors"}).}

\item{legend}{logical, if TRUE a legend for \code{z} is plotted.}

\item{drop.levels}{logical, if TRUE unused levels of the \code{z} variable are dropped.}

\item{pt.col}{color of points in the scatter plot.}

\item{pt.alpha}{numeric, transparency of points in the scatter plot.}

\item{nbins}{integer (active when \code{type="density-hexbin"}), number of bins.}

\item{palette}{color palette; available options \code{"main"}, \code{"cool"}, \code{"hot"}, \code{"mixed"}, \code{"grey"}, \code{"bwr"} (blue, white, red).}
}
\value{
A ggplot2 object.
}
\description{
Plots different kinds of charts based on shot coordinates
}
\details{
The \code{data} dataframe could also be a play-by-play dataset provided that rows corresponding to events different from field shots have missing \code{x} and \code{y} coordinates.

\code{x} and \code{y} coordinates must be expressed in feets; the origin of the axes is positioned at the center of the field.
}
\examples{
PbP <- PbPmanipulation(PbP.BDB)
subdata <- subset(PbP, player=="Kevin Durant")
subdata$xx <- subdata$original_x/10
subdata$yy <- subdata$original_y/10-41.75
shotchart(data=subdata, x="xx", y="yy", scatter=TRUE)
shotchart(data=subdata, x="xx", y="yy", scatter=TRUE, z="result")
shotchart(data=subdata, x="xx", y="yy", scatter=TRUE, z="result",
          bg.col="black", courtline.col="white", palette="hot")
shotchart(data=subdata, x="xx", y="yy", result="result",
          type="sectors", sectline.col="gray", text.col="red")
shotchart(data=subdata, x="xx", y="yy", z="playlength", result="result",
          type="sectors",  num.sect=5)
shotchart(data=subdata, x="xx", y="yy", type="density-polygons", palette="bwr")
shotchart(data=subdata, x="xx", y="yy", type="density-raster",
          scatter=TRUE, pt.col="tomato", pt.alpha=0.1)
shotchart(data=subdata, x="xx", y="yy", type="density-hexbin", nbins=30)
}
\references{
P. Zuccolotto and M. Manisera (2020) Basketball Data Science: With Applications in R. CRC Press.
}
\seealso{
\code{\link{drawNBAcourt}}, \code{\link[ggplot2]{geom_density_2d}}, \code{\link[ggplot2]{geom_hex}}
}
\author{
Marco Sandri, Paola Zuccolotto, Marica Manisera (\email{basketball.analyzer.help@gmail.com})
}
