% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbg-cnbd-k.R
\name{mbgcnbd.ExpectedCumulativeTransactions}
\alias{mbgcnbd.ExpectedCumulativeTransactions}
\alias{bgcnbd.ExpectedCumulativeTransactions}
\title{(M)BG/CNBD-k Expected Cumulative Transactions}
\usage{
mbgcnbd.ExpectedCumulativeTransactions(params, T.cal, T.tot, n.periods.final)

bgcnbd.ExpectedCumulativeTransactions(params, T.cal, T.tot, n.periods.final)
}
\arguments{
\item{params}{A vector with model parameters \code{k}, \code{r},
\code{alpha}, \code{a} and \code{b}, in that order.}

\item{T.cal}{A vector to represent customers' calibration period lengths.}

\item{T.tot}{End of holdout period. Must be a single value, not a vector.}

\item{n.periods.final}{Number of time periods in the calibration and holdout
periods.}
}
\value{
Vector of length \code{n.periods.final} with expected cumulative
  total repeat transactions by all customers.
}
\description{
Calculates the expected cumulative total repeat transactions by all customers
for the calibration and holdout periods.
}
\details{
Note: Computational time increases with the number of unique values of
\code{T.cal}.
}
\examples{
\dontrun{
data("groceryElog")
cbs <- elog2cbs(groceryElog)
params <- mbgcnbd.EstimateParameters(cbs, k = 2)
# Returns a vector containing expected cumulative repeat transactions for 104
# weeks, with every eigth week being reported.
mbgcnbd.ExpectedCumulativeTransactions(params,
  T.cal = cbs$T.cal,
  T.tot = 104,
  n.periods.final = 104 / 8)
}
}
