% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cens_data_check.R
\name{cens_data_check}
\alias{cens_data_check}
\title{Censoring data check}
\usage{
cens_data_check(xleft, xright)
}
\arguments{
\item{xleft}{left bounds for the censored dataset. Can be a real number or NA}

\item{xright}{right bounds for the censored dataset}
}
\description{
Checks that a censored dataset is valid. This performs two checks: check that the dataset does not contain only NA, and check that the for interval censored data, the bounds are in the right order.
}
\details{
For internal use
}
\examples{

## The function is currently defined as
function(xleft, xright) {
  if (any(xright < xleft, na.rm = T)) {
    stop("in censored data, left bound not always smaller than right bound")
  }
  if (any(mapply(FUN = function(xileft, xiright) {
    is.na(xileft) & is.na(xiright)
  }, xleft, xright))) {
    stop("in censored data, there is an NA NA")
  }
}
}
\keyword{internal}
