% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_sub_lineup.R
\name{do_sub_lineup}
\alias{do_sub_lineup}
\title{Compute ACB sub-lineups}
\usage{
do_sub_lineup(data, elem_choose)
}
\arguments{
\item{data}{Data frame with the lineups (quintets).}

\item{elem_choose}{Numeric: 4, 3 or 2.}
}
\value{
Data frame. Each row is a different sub-lineup. This is the meaning of the 
columns that might not be explanatory by themselves:
\itemize{
  \strong{team_in}: Time point when that sub-lineup starts playing together.
  \strong{team_out}: Time point when that sub-lineup stops playing together 
  (because there is a substitution).
  \strong{time_seconds}: Total of seconds that the sub-lineup played.
  \strong{plus_minus}: Plus/minus achieved by the sub-lineup. This is the difference
  between the game score of the previous lineup and of the current one.
  \strong{plus_minus_poss}: Plus/minus per possession.
}
}
\description{
Compute all the sub-lineups that a given team shows during a game. They can
be made up of four, three or two players.
}
\note{
A possession lasts 24 seconds in the ACB league.
}
\examples{
library(dplyr)
df0 <- acb_vbc_cz_pbp_2223

day_num <- unique(acb_vbc_cz_pbp_2223$day)
game_code <- unique(acb_vbc_cz_pbp_2223$game_code)

acb_games_2223_sl <- acb_vbc_cz_sl_2223 \%>\%
  filter(period == "1C")

df1 <- do_prepare_data(df0, day_num, 
                       acb_games_2223_sl, acb_games_2223_info,
                       game_code)
                
df2 <- do_lineup(df1, day_num, game_code, "Valencia Basket", FALSE)    

df3 <- do_sub_lineup(df2, 4)
#df3

}
\author{
Guillermo Vinue
}
