% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argos_files.R
\name{vdp_oscillator}
\alias{vdp_oscillator}
\title{Van der Pol Oscillator}
\usage{
vdp_oscillator(n, dt, init_conditions, mu, snr = Inf)
}
\arguments{
\item{n}{Number of time points (rounded to the nearest integer).}

\item{dt}{Time step between observations.}

\item{init_conditions}{Initial conditions as a numeric vector of length 2.}

\item{mu}{Parameter controlling the nonlinear damping level of the system.}

\item{snr}{Signal-to-noise ratio (in dB). Use Inf for no noise.}
}
\value{
A numeric matrix representing the system's state over time. Each row
        corresponds to a time point, and each column represents a variable.
}
\description{
Simulates the Van der Pol oscillator with optional noise.
}
\details{
This function simulates a Van der Pol oscillator with the specified parameters.
It uses the specified time step and initial conditions to compute the system's
state over time. If a non-Infinite SNR is provided, Gaussian noise is added to
the system.
}
\examples{
# Simulate a Van der Pol oscillator with 100 time points and no noise
data <- vdp_oscillator(
  n = 100,
  dt = 0.01,
  init_conditions = c(-1, 1),
  mu = 1.2,
  snr = Inf
)

}
