% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsh_properties.R
\name{jaccard_probability}
\alias{jaccard_probability}
\title{Find Probability of Match Based on Similarity}
\usage{
jaccard_probability(similarity, n_bands, band_width)
}
\arguments{
\item{similarity}{the similarity of the two strings you want to compare}

\item{n_bands}{The number of LSH bands used in hashing.}

\item{band_width}{The number of hashes in each band.}
}
\value{
a decimal number giving the probability that the two items will be
returned as a candidate pair from the minhash algorithm.
}
\description{
This is a port of the
\href{https://docs.ropensci.org/textreuse/reference/lsh_probability.html}{lsh_probability}
function from the
\href{https://cran.r-project.org/package=textreuse}{textreuse}
package, with arguments changed to reflect the hyperparameters in this
package. It gives the probability that two strings of jaccard similarity
\code{similarity} will be matched, given the chosen bandwidth and number of
bands.
}
\examples{
# Find the probability two pairs will be matched given they have a
# jaccard_similarity of .8, band width of 5, and 50 bands:
jaccard_probability(.8, n_bands = 50, band_width = 5)
}
