% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explicit_guide_factor.R
\name{implicit_guide.factor}
\alias{implicit_guide.factor}
\title{Coerce Factor Guide to Something More Implicit}
\usage{
\method{implicit_guide}{factor}(x, ...)
}
\arguments{
\item{x}{factor}

\item{...}{ignored}
}
\value{
factor
}
\description{
Coerces factor guide-like attributes to 'guide'.
The attribute 'guide' generally suggests a guide
to interpretation of a data item, such as units, formats, codelists,
and encodings.  The idea here is to replace these with 'guide':
i.e., to undo the effects of \code{\link{explicit_guide.dvec}}.
If guide attribute is still present, the explicit attribute is removed.
Otherwise the explicit element is renamed.
}
\examples{
library(magrittr)
x <- data.frame(RACE = factor(1))
x \%<>\% modify(RACE, label = 'race', guide = list(white = 0, black = 1, asian = 2))
x \%>\% decorations
x \%>\% explicit_guide \%>\% decorations
x \%>\% explicit_guide \%>\% implicit_guide \%>\% decorations
x \%>\% explicit_guide(simplify = FALSE) \%>\% decorations
x \%>\% explicit_guide(simplify = FALSE) \%>\% implicit_guide \%>\% decorations
x \%<>\% explicit_guide
a <- x$RACE
str(a)
str(a \%>\% implicit_guide)
}
\seealso{
Other explicit_guide: 
\code{\link{explicit_guide}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{explicit_guide.dvec}()},
\code{\link{explicit_guide.factor}()},
\code{\link{explicit_guide.yamlet}()},
\code{\link{implicit_guide}()},
\code{\link{implicit_guide.data.frame}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{infer_guide}()}

Other dvec: 
\code{\link{[.dvec}()},
\code{\link{[<-.dvec}()},
\code{\link{[[.dvec}()},
\code{\link{[[<-.dvec}()},
\code{\link{as.data.frame.dvec}()},
\code{\link{as_dvec}()},
\code{\link{as_dvec.character}()},
\code{\link{as_dvec.complex}()},
\code{\link{as_dvec.dvec}()},
\code{\link{as_dvec.integer}()},
\code{\link{as_dvec.logical}()},
\code{\link{as_dvec.numeric}()},
\code{\link{c.dvec}()},
\code{\link{classified.dvec}()},
\code{\link{desolve.dvec}()},
\code{\link{explicit_guide.data.frame}()},
\code{\link{format.dvec}()},
\code{\link{implicit_guide.dvec}()},
\code{\link{length.dvec}()},
\code{\link{print.dvec}()},
\code{\link{resolve.classified}()},
\code{\link{resolve.dvec}()},
\code{\link{resolve.factor}()},
\code{\link{unclassified.dvec}()}
}
\concept{dvec}
\concept{explicit_guide}
\keyword{internal}
