% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ewtp.R
\name{EWTP}
\alias{EWTP}
\title{Expected win time against trial population}
\usage{
EWTP(
  n,
  m,
  nunique,
  maxfollow,
  untimes,
  Time,
  Delta,
  dist,
  markov_ind,
  cov,
  trt
)
}
\arguments{
\item{n}{The total number of trial participants.}

\item{m}{The number of events in the hierarchy.}

\item{nunique}{The number of unique combined arm event times (returned from wintime::markov() or wintime::km()).}

\item{maxfollow}{The max combined arm follow up time (days) (returned from wintime::markov() or wintime::km()).}

\item{untimes}{A vector containing unique combined arm event times (days) (returned from wintime::markov() or wintime::km()).}

\item{Time}{A m x n matrix of event times (days). Rows should represent events and columns should represent participants. Rows should be
in increasing order of clinical severity.}

\item{Delta}{A m x n matrix of event indicators Rows should represent events and columns should represent participants. Rows should be
in increasing order of clinical severity.}

\item{dist}{A matrix of combined arm state probabilities (returned from wintime::markov() or wintime::km()).}

\item{markov_ind}{An indicator of the model type used (1 for Markov, 0 for Kaplan-Meier).}

\item{cov}{A n x p matrix of covariate values, where p is the number of covariates.}

\item{trt}{A vector of length n containing treatment arm indicators (1 for treatment, 0 for control).}
}
\value{
A list containing: The estimated treatment effect from the linear regression model, the variance, the Z-statistic, the components of the treatment effect, and the variance of the components.
}
\description{
Calculates the combined arm state space probabilities using a Markov model or a Kaplan-Meier model (recommended). This function uses these
probabilities to compare each participant's clinical state to a distribution of combined arm states.
}
