% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_llt_smq.R
\name{get_llt_smq}
\alias{get_llt_smq}
\title{Extract low level terms from SMQs}
\usage{
get_llt_smq(
  smq,
  smq_scope = c("narrow", "broad"),
  smq_list,
  smq_content,
  smq_list_content = deprecated()
)
}
\arguments{
\item{smq}{A named list of character vector(s).}

\item{smq_scope}{A character vector. One of "narrow" or "broad".}

\item{smq_list}{A data.table. A list of SMQs.}

\item{smq_content}{A data.table. A list of SMQs content.}

\item{smq_list_content}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}}
}
\value{
A named list of integers. Low-level term codes.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}} Collect llts from \code{smq_list}
and \code{smq_content} data.tables, given an SMQ.
}
\details{
\code{get_llt_smq()} is an \emph{ID collector} function. SMQ stands for Standardized MedDRA query.
\code{get_llt_smq()}only works with NON-algorithmic SMQs
(this status is given in the smq_list table).
See \code{\link{smq_list_}} and \code{\link{smq_content_}}. You can choose
between the narrow and the broad scope of the SMQ.
If you want to work with the SOC hierarchy, use \code{\link[=get_llt_soc]{get_llt_soc()}}.
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
## Finding llt codes for Embolism (SMQ)

smq_sel <- rlang::list2(
  embolism = "Embolic and thrombotic events, venous (SMQ)"
 )
get_llt_smq(smq_sel,
                smq_scope = "narrow",
                smq_list = smq_list_,
                smq_content = smq_content_
                )

# You can query multiple SMQs in one item, and query high level SMQs
smq_sel2 <-
  rlang::list2(
    sepsis = c("Sepsis (SMQ)","Toxic-septic shock conditions (SMQ)"),
    ischemic_heart_disease = c("Ischaemic heart disease (SMQ)")
  )

get_llt_smq(smq_sel2,
            smq_scope = "narrow",
            smq_list = smq_list_,
            smq_content = smq_content_
            )
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=get_llt_soc]{get_llt_soc()}}
}
\keyword{data_management}
\keyword{llt}
\keyword{meddra}
\keyword{smq}
