% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/type.R
\name{type_of}
\alias{type_of}
\alias{type_alike}
\title{Fuzzily Compare Types of Objects}
\usage{
type_of(object)

type_alike(target, current, settings = NULL)
}
\arguments{
\item{object}{the object to check the type of}

\item{target}{the object to test type alikeness against}

\item{current}{the object to test the type alikeness of}

\item{settings}{NULL, or a list as produced by \code{\link[=vetr_settings]{vetr_settings()}}}
}
\value{
For \code{type_of} character(1L) the type of the object, for \code{type_alike}
either TRUE, or a string describing why the types are not alike.
}
\description{
Type evaluation and comparison is carried out with special treatment for
numerics, integers, and function types.  Whole number NA-free numeric vectors
of sufficiently short length (<100 by default) representable in the integer
type are considered to be type integer.  Closures, built-ins, and specials
are all treated as type closure.
}
\details{
Specific behavior can be tuned with the \code{type.mode} parameter to the
\code{\link[=vetr_settings]{vetr_settings()}} object passed as the \code{settings} parameter to this function.
}
\examples{
type_of(1.0001)          # numeric
type_of(1.0)             # integer (`typeof` returns numeric)
type_of(1)               # integer (`typeof` returns numeric)
type_of(sum)             # closure (`typeof` returns builtin)
type_of(`$`)             # closure (`typeof` returns special)

type_alike(1L, 1)
type_alike(1L, 1.1)
type_alike(integer(), numeric(100))
type_alike(integer(), numeric(101))  # too long
}
\seealso{
\code{\link[=alike]{alike()}}, \code{\link[=vetr_settings]{vetr_settings()}}, in particular the section about
the \code{type.mode} parameter which affects how this function behaves.
}
