% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write-docker.R
\name{vetiver_prepare_docker}
\alias{vetiver_prepare_docker}
\title{Generate files necessary to build a Docker container for a vetiver model}
\usage{
vetiver_prepare_docker(
  board,
  name,
  version = NULL,
  path = ".",
  predict_args = list(),
  docker_args = list()
)
}
\arguments{
\item{board}{A pin board, created by \code{\link[pins:board_folder]{board_folder()}}, \code{\link[pins:board_connect]{board_connect()}},
\code{\link[pins:board_url]{board_url()}} or another \code{board_} function.}

\item{name}{Pin name.}

\item{version}{Retrieve a specific version of a pin. Use \code{\link[pins:pin_versions]{pin_versions()}} to
find out which versions are available and when they were created.}

\item{path}{A path to write the Plumber file, Dockerfile, and lockfile,
capturing the model's dependencies.}

\item{predict_args}{A list of optional arguments passed to \code{\link[=vetiver_api]{vetiver_api()}}
such as the prediction \code{type}.}

\item{docker_args}{A list of optional arguments passed to
\code{\link[=vetiver_write_docker]{vetiver_write_docker()}} such as the \code{lockfile} name or whether to use
\code{rspm}. Do not pass \code{additional_pkgs} here, as this function uses
\code{additional_pkgs = required_pkgs(board)}.}
}
\value{
An invisible \code{TRUE}.
}
\description{
Deploying a vetiver model via Docker requires several files. Use this
function to create these needed files in the directory located at \code{path}.
}
\details{
The function \code{vetiver_prepare_docker()} uses:
\itemize{
\item \code{\link[=vetiver_write_plumber]{vetiver_write_plumber()}} to create a Plumber file and
\item \code{\link[=vetiver_write_docker]{vetiver_write_docker()}} to create a Dockerfile and renv lockfile
}

These modular functions are available for more advanced use cases. For
models such as keras and torch, you will need to edit the generated
Dockerfile to, for example, \verb{COPY requirements.txt requirements.txt} or
similar.
}
\examples{
\dontshow{if (interactive() || identical(Sys.getenv("IN_PKGDOWN"), "true")) withAutoprint(\{ # examplesIf}
library(pins)
b <- board_temp(versioned = TRUE)
cars_lm <- lm(mpg ~ ., data = mtcars)
v <- vetiver_model(cars_lm, "cars_linear")
vetiver_pin_write(b, v)

vetiver_prepare_docker(b, "cars_linear", path = tempdir())
\dontshow{\}) # examplesIf}
}
