% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knitr.R
\name{setup_knitr}
\alias{setup_knitr}
\title{Use vcr in vignettes}
\usage{
setup_knitr(prefix = NULL, dir = "_vcr", ...)
}
\arguments{
\item{prefix}{An prefix for the cassette name to make cassettes unique across
vignettes. Defaults to the file name (without extension) of the currently
executing vignette.}

\item{dir}{Directory where to create the cassette file. Default: `"_vcr"``.}

\item{...}{Other arguments passed on to \code{\link[=insert_cassette]{insert_cassette()}}.}
}
\description{
\code{setup_knitr()} registers a knitr hook to make it easy to use vcr inside a
vignette. First call \code{setup_knitr()} in your setup chunk (or other chunk
early in the document):

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r setup\}
#| include: false
vcr::setup_knitr()
```
}\if{html}{\out{</div>}}

Then, in a chunk where you want to use a cassette, set the \code{cassette} chunk
option to the name of the cassette:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r\}
#| cassette: name
req <- httr2::request("http://r-project.org")
resp <- httr2::req_perform(req)
```
}\if{html}{\out{</div>}}

Or if you have labelled the chunk, you can use \code{cassette: true} to use the
chunk label as the cassette name:

\if{html}{\out{<div class="sourceCode">}}\preformatted{```\{r\}
#| label: cassette-name
#| cassette: true
req <- httr2::request("http://r-project.org")
resp <- httr2::req_perform(req)
```
}\if{html}{\out{</div>}}

You can build your vignettes however you usually do (from the command line,
with pkgdown, with RStudio/Positron, etc).
}
