% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specs.R
\name{v_specs_axes}
\alias{v_specs_axes}
\title{Axes configuration}
\usage{
v_specs_axes(
  vc,
  position = c("left", "bottom", "right", "top", "angle", "radius"),
  ...,
  remove = FALSE
)
}
\arguments{
\item{vc}{An htmlwidget created with \code{\link[=vchart]{vchart()}}.}

\item{position}{Position of the axe on the chart.}

\item{...}{Configuration options.}

\item{remove}{If \code{TRUE} then axe is removed and other parameters are ignored.}
}
\value{
A \code{\link[=vchart]{vchart()}} \code{htmlwidget} object.
}
\description{
Axes configuration
}
\examples{

library(vchartr)

# Configure some options for axes
vchart() \%>\%
  v_line(aes(x = month.name, y = sample(5:25, 12))) \%>\%
  v_specs_axes(
    position = "left",
    title = list(
      visible = TRUE,
      text = "Y axis title",
      position = "start"
    ),
    label = list(
      formatMethod = JS("val => `${val}°C`")
    ),
    domainLine = list(
      visible = TRUE,
      style = list(stroke = "#000")
    ),
    tick = list(
      visible = TRUE,
      tickStep = 2,
      tickSize = 6,
      style = list(stroke = "#000")
    ),
    grid = list(
      visible = TRUE,
      style = list(lineDash = list(0), stroke = "#6E6E6E", zIndex = 100)
    )
  )\%>\%
  v_specs_axes(
    position = "bottom",
    title = list(
      visible = TRUE,
      text = "X axis title",
      position = "end"
    ),
    domainLine = list(
      visible = TRUE,
      style = list(stroke = "#000")
    ),
    tick = list(
      visible = TRUE,
      tickStep = 2,
      tickSize = 6,
      style = list(stroke = "#000")
    ),
    grid = list(
      visible = TRUE,
      style = list(lineDash = list(0)),
      alternateColor = c("#F2F2F2", "#FFFFFF"),
      alignWithLabel = TRUE
    )
  )



# By default vline add an axe on the left
vchart() \%>\%
  v_line(aes(x = month.name, y = sample(5:25, 12))) \%>\%
  v_specs_axes(position = "left", remove = TRUE) \%>\%
  v_specs_axes(position = "right", type = "linear")

# Use secondary axes
vchart() \%>\%
  v_line(aes(x = month.name, y = sample(5:25, 12)), serie_id = "serie_left") \%>\%
  v_line(aes(x = month.name, y = sample(5:25 * 100, 12)), serie_id = "serie_right") \%>\%
  v_specs_axes(position = "left", seriesId = "serie_left") \%>\%
  v_specs_axes(position = "right", type = "linear", seriesId = "serie_right")


}
