% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask_variables_rowwise.R
\name{mask_variables_rowwise}
\alias{mask_variables_rowwise}
\title{Mask categorical labels across multiple columns rowwise in a data frame}
\usage{
mask_variables_rowwise(data, ..., prefix = "masked_group_")
}
\arguments{
\item{data}{A data frame.}

\item{...}{Columns to mask using tidyselect semantics. All arguments are combined into
a single set. Each can be:
\itemize{
\item Bare column names (e.g., \code{var1, var2})
\item A tidyselect expression (e.g., \code{starts_with("treat_")})
\item A character vector of column names (e.g., \code{c("var1", "var2")})
}}

\item{prefix}{character string to use as prefix for masked labels.
Default is "masked_group_"}
}
\value{
A data frame with labels masked rowwise within the selected columns.
}
\description{
For each row, independently mask labels within the selected columns.
All selected columns are combined into a single set and processed together.
To mask different variable groups separately, call the function multiple times.
}
\examples{
df <- data.frame(
  treat_1 = c("control", "treatment", "placebo"),
  treat_2 = c("treatment", "placebo", "control"),
  treat_3 = c("placebo", "control", "treatment"),
  condition_a = c("A", "B", "A"),
  condition_b = c("B", "A", "B"),
  id = 1:3
)

set.seed(1037)
# Mask one set of variables
library(dplyr)
df |> mask_variables_rowwise(starts_with("treat_"))

# Using character vectors
df |> mask_variables_rowwise(c("treat_1", "treat_2", "treat_3"))

# Mask multiple sets separately
df |>
  mask_variables_rowwise(starts_with("treat_")) |>
  mask_variables_rowwise(c("condition_a", "condition_b"))

# Example with custom prefix
df |> mask_variables_rowwise(starts_with("treat_"), prefix = "group_")

}
\seealso{
\code{\link{mask_labels}} for masking a single vector,
\code{\link{mask_variables}} for masking multiple variables, and
\code{\link{mask_names}} for masking variable names.
}
\keyword{mask}
