% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/car_precision.R
\name{intrinsic_car_precision}
\alias{intrinsic_car_precision}
\title{Intrinsic CAR (ICAR) precision matrix}
\usage{
intrinsic_car_precision(
  A,
  tau = 1,
  scale = TRUE,
  symmetrize = FALSE,
  check = TRUE
)
}
\arguments{
\item{A}{Square adjacency/weight matrix.}

\item{tau}{Positive scalar precision multiplier.}

\item{scale}{Logical; if `TRUE`, applies Besag scaling.}

\item{symmetrize}{If `TRUE`, replaces `A` by `(A + t(A))/2`.}

\item{check}{If `TRUE`, performs basic validation and warnings.}
}
\value{
A symmetric sparse precision matrix (`"dsCMatrix"`).
}
\description{
Constructs the intrinsic CAR precision matrix
\deqn{Q = \tau \, s (D - A),}
where \eqn{s} is a scaling constant chosen so that the
geometric mean of the marginal variances equals 1.
}
\details{
The resulting precision matrix is singular with rank deficiency
equal to the number of connected components.
}
\references{
Sørbye, S. H. and Rue, H. (2014).
Scaling intrinsic Gaussian Markov random field priors.
}
