% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1_plots.R
\name{ggheat}
\alias{ggheat}
\title{ggheat}
\usage{
ggheat(
  dat,
  group,
  cluster = FALSE,
  color = c("#2874C5", "white", "#f87669"),
  legend_color = c("#2874C5", "#f87669", "#e6b707", "#868686", "#66C2A5", "#FC8D62",
    "#8DA0CB", "#E78AC3", "#A6D854", "#FFD92F", "#E5C494", "#B3B3B3"),
  show_rownames = TRUE,
  show_colnames = TRUE,
  cluster_rows = FALSE,
  cluster_cols = FALSE,
  groupname = "group",
  expname = "exp",
  fill_mid = TRUE
)
}
\arguments{
\item{dat}{expression matrix for plot}

\item{group}{group for expression colnames}

\item{cluster}{logical,cluster in both rows and column or not, default F,now replaced by cluster_rows and cluster_cols.}

\item{color}{color for heatmap}

\item{legend_color}{color for legend}

\item{show_rownames}{logical,show rownames in plot or not, default T}

\item{show_colnames}{logical,show colnames in plot or not, default T}

\item{cluster_rows}{logical, if rows (on the plot) should be clustered, default F}

\item{cluster_cols}{logical, if column (on the plot) should be clustered, default F}

\item{groupname}{name of group legend}

\item{expname}{name of exp legend}

\item{fill_mid}{use median value as geom_tile fill midpoint}
}
\value{
a ggplot object
}
\description{
draw heatmap plot with annotation by ggplot2
}
\examples{
exp_dat = matrix(sample(100:1000,40),ncol = 4)
exp_dat[1:(nrow(exp_dat)/2),] =  exp_dat[1:(nrow(exp_dat)/2),]-1000
rownames(exp_dat) = paste0("sample",1:nrow(exp_dat))
colnames(exp_dat) = paste0("gene",1:ncol(exp_dat))
group = rep(c("A","B"),each = nrow(exp_dat)/2)
group = factor(group,levels = c("A","B"))
ggheat(exp_dat,group)
ggheat(exp_dat,group,cluster_rows = TRUE)
ggheat(exp_dat,group,cluster_rows = TRUE,show_rownames = FALSE,
       show_colnames = FALSE,groupname = "risk",expname = "expression")
}
\author{
Xiaojie Sun
}
