% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tw_search.R
\name{tw_search_item}
\alias{tw_search_item}
\title{Search for Wikidata properties in Wikidata and return Wikidata id, label, and
description.}
\usage{
tw_search_item(
  search,
  language = tidywikidatar::tw_get_language(),
  response_language = tidywikidatar::tw_get_language(),
  limit = 10,
  include_search = FALSE,
  wait = 0,
  cache = NULL,
  overwrite_cache = FALSE,
  cache_connection = NULL,
  disconnect_db = TRUE
)
}
\arguments{
\item{search}{A string to be searched in Wikidata}

\item{language}{Language to be used for the search. Can be set once per
session with \code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full
list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{the
dedicated Wikimedia page}.}

\item{response_language}{Language to be used for the returned labels and
descriptions. Corresponds to the \code{uselang} parameter of the MediaWiki API,
as described
\href{https://www.wikidata.org/w/api.php?action=help&modules=wbsearchentities}{in
the official documentation}. Can be set once per session with
\code{\link[=tw_set_language]{tw_set_language()}}. If not set, defaults to "en". For a full list, see
\href{https://www.wikidata.org/wiki/Help:Wikimedia_language_codes/lists/all}{all
available language codes}.}

\item{limit}{Maximum numbers of responses to be given.}

\item{include_search}{Logical, defaults to \code{FALSE}. If \code{TRUE}, the search is
returned as an additional column.}

\item{wait}{In seconds, defaults to 0. Time to wait between queries to
Wikidata. If data are cached locally, wait time is not applied. If you are
running many queries systematically you may want to add some waiting time
between queries.}

\item{cache}{Defaults to \code{NULL}. If given, it should be given either \code{TRUE}
or \code{FALSE.} Typically set with \code{\link[=tw_enable_cache]{tw_enable_cache()}} or \code{\link[=tw_disable_cache]{tw_disable_cache()}}.}

\item{overwrite_cache}{Defaults to \code{FALSE}. If \code{TRUE}, overwrites cache.}

\item{cache_connection}{Defaults to \code{NULL}. If \code{NULL}, and caching is
enabled, \code{tidywikidatar} will use a local sqlite database. A custom
connection to other databases can be given (see vignette \code{caching} for
details).}

\item{disconnect_db}{Defaults to \code{TRUE}. If \code{FALSE}, leaves the connection to
cache open.}
}
\value{
A data frame (a tibble) with three columns (\code{id}, \code{label}, and
\code{description}), and as many rows as there are results (by default, limited
to 10).
}
\description{
This search returns only items, use \code{\link[=tw_search_property]{tw_search_property()}} for properties.
}
\examples{
tw_search_item(search = "Sylvia Pankhurst")
}
