% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust.R
\name{adjust_font}
\alias{adjust_font}
\title{Adjust font}
\usage{
adjust_font(plot, fontsize = 7, family = NULL, face = NULL, color = "black")
}
\arguments{
\item{plot}{A \code{tidyplot} generated with the function \code{tidyplot()}.}

\item{fontsize}{Font size in points. Defaults to \code{7}.}

\item{family}{The typeface to use. The validity of this value will depend on
the graphics device being used for rendering the plot. See
\href{https://systemfonts.r-lib.org/articles/systemfonts.html}{the systemfonts vignette}
for guidance on the best way to access fonts installed on your computer.
The values \code{"sans"}, \code{"serif"}, and \code{"mono"} should always be valid and
will select the default typeface for the respective styles. However, what
is considered default is dependant on the graphics device and the operating
system.}

\item{face}{Font face ("plain", "italic", "bold", "bold.italic")}

\item{color}{A hex color for the stroke color. For example, \code{"#FFFFFF"} for white.}
}
\value{
A \code{tidyplot} object.
}
\description{
Adjust font
}
\examples{
# Plot without adjustments
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar()

# Increase font size
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_font(fontsize = 16)

# Change font family
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_font(family = "mono")

# Change font face
study |>
  tidyplot(x = treatment, y = score, color = treatment) |>
  add_data_points_beeswarm() |>
  add_mean_bar(alpha = 0.4) |>
  add_sem_errorbar() |>
  adjust_font(face = "bold")

}
