% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-tidycpt.R
\name{file_name}
\alias{file_name}
\title{Obtain a descriptive filename for a tidycpt object}
\usage{
file_name(x, data_name_slug = "data")
}
\arguments{
\item{x}{A \linkS4class{tidycpt} object}

\item{data_name_slug}{character string that will identify the data set used
in the file name}
}
\value{
A \code{character} string giving a unique file name.
}
\description{
Obtain a descriptive filename for a tidycpt object
}
\details{
\code{\link[=file_name]{file_name()}} generates a random, unique string indicating the algorithm and
\code{\link[=fitness]{fitness()}} for a \linkS4class{tidycpt} object.
}
\examples{
# Generate a unique name for the file
DataCPSim |>
  segment(method = "pelt") |>
  file_name()
}
