% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test-package.R
\name{test_package}
\alias{test_package}
\alias{test_check}
\alias{test_local}
\title{Run all tests in a package}
\usage{
test_package(package, reporter = check_reporter(), ...)

test_check(package, reporter = check_reporter(), ...)

test_local(
  path = ".",
  reporter = NULL,
  ...,
  load_package = "source",
  shuffle = FALSE
)
}
\arguments{
\item{package}{If these tests belong to a package, the name of the package.}

\item{reporter}{Reporter to use to summarise output. Can be supplied
as a string (e.g. "summary") or as an R6 object
(e.g. \code{SummaryReporter$new()}).

See \link{Reporter} for more details and a list of built-in reporters.}

\item{...}{Additional arguments passed to \code{\link[=test_dir]{test_dir()}}}

\item{path}{Path to directory containing tests.}

\item{load_package}{Strategy to use for load package code:
\itemize{
\item "none", the default, doesn't load the package.
\item "installed", uses \code{\link[=library]{library()}} to load an installed package.
\item "source", uses \code{\link[pkgload:load_all]{pkgload::load_all()}} to a source package.
To configure the arguments passed to \code{load_all()}, add this
field in your DESCRIPTION file:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Config/testthat/load-all: list(export_all = FALSE, helpers = FALSE)
}\if{html}{\out{</div>}}
}}

\item{shuffle}{If \code{TRUE}, randomly reorder the top-level expressions
in the file.}
}
\value{
A list (invisibly) containing data about the test results.
}
\description{
\itemize{
\item \code{test_local()} tests a local source package.
\item \code{test_package()} tests an installed package.
\item \code{test_check()} checks a package during \verb{R CMD check}.
}

See \code{vignette("special-files")} to learn about the various files that
testthat works with.
}
\section{\verb{R CMD check}}{

To run testthat automatically from \verb{R CMD check}, make sure you have
a \code{tests/testthat.R} that contains:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(testthat)
library(yourpackage)

test_check("yourpackage")
}\if{html}{\out{</div>}}
}

\section{Environments}{

Each test is run in a clean environment to keep tests as isolated as
possible. For package tests, that environment inherits from the package's
namespace environment, so that tests can access internal functions
and objects.
}

