% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-expect.R
\name{expect-deprec}
\alias{expect-deprec}
\alias{expect_func}
\alias{expect_join}
\alias{expect_similar}
\alias{expect_allany}
\title{Deprecated expectation functions}
\usage{
expect_func(var, ...)

expect_join(data2, by = NULL, not = FALSE, flt = TRUE, data = get_testdata())

expect_similar(
  var,
  data2,
  var2,
  flt = TRUE,
  flt2 = flt,
  threshold = 0.05,
  min = 100,
  data = get_testdata()
)

expect_allany(
  vars,
  func,
  flt = TRUE,
  data = get_testdata(),
  args = list(),
  allany = c(chk_filter_all, chk_filter_any),
  func_desc = NULL
)
}
\arguments{
\item{var}{An unquoted column name to test.}

\item{...}{Arguments to pass to \code{expect_allany()}.}

\item{data2}{The data frame to compare against.}

\item{by}{A character vector of columns to join by. See \code{\link[dplyr:mutate-joins]{dplyr::join()}} for
details.}

\item{not}{Reverse the results of the check?}

\item{flt}{<\code{\link[dplyr:dplyr_data_masking]{data-masking}}> A filter specifying
a subset of the data frame to test.}

\item{data}{A data frame to test. The \link[=global-data]{global test data} is used
by default.}

\item{var2}{An unquoted column name from data2.}

\item{flt2}{A filter specifying a subset of data2 to test.}

\item{threshold}{The maximum proportional difference allowed between the two
categories.}

\item{min}{The minimum number of responses for a category to allow
comparison. This avoids small categories raising spurious errors.}

\item{vars}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> A set of columns to
test.}

\item{func}{A function to use for testing that takes a vector as the first
argument and returns a logical vector of the same length showing whether an
element passed or failed.}

\item{args}{A named list of arguments to pass to \code{func}.}

\item{allany}{The function to combine the \code{func} results for each row.}

\item{func_desc}{A human friendly description of \code{func} to use in the
expectation failure message.}
}
\value{
\verb{expect_*()} functions are mainly called for their side effects. The
expectation signals its result (e.g. "success", "failure"), which is logged
by the current \link[testthat:Reporter]{test reporter}. In a non-testing
context the expectation will raise an error with class
\code{expectation_failure} if it fails.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}}

These functions are deprecated.
}
\seealso{
\link[=generic-expectations]{Generic Expectation Functions}

\link[=datacomp-expectations]{Expectations: comparisons}
}
\keyword{internal}
