% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_surveynnet.R
\name{predict.surveynnet}
\alias{predict.surveynnet}
\title{Predict response from fitted nnet, using new data}
\usage{
\method{predict}{surveynnet}(object, newdat, ...)
}
\arguments{
\item{object}{The surveynnet object (returned by \code{surveynnet()})}

\item{newdat}{The matrix or data frame of test examples. Must be of the same structure
as the data matrix used to fit the surveynnet object.}

\item{...}{arguments passed to or from other methods}
}
\value{
The matrix/vector of values returned by the trained network. Note: it is possible
to pass type = "raw" or type = "class" as appropriate. See \code{predict.nnet()} for more details.
}
\description{
Predict response from fitted nnet, using new data
}
\examples{
# From the example in `surveynnet` help file:
y <- body_fat$pct_body_fat
x <- body_fat[,c("Weight_kg", "Height_cm", "Age")]
weight <- body_fat$survey_wt
strat <- body_fat$stratum
clust <- body_fat$cluster
y[strat==1] <- y[strat==1] + 30*0.00015*rnorm(sum(strat==1))
y[strat==2] <- y[strat==2] + 30*0.15*rnorm(sum(strat==2))
myout <- surveynnet(x,y,weight = weight, strat = strat, clust=clust)
newdat <-  2*x+rnorm(dim(x)[1])
predict(myout, newdat = newdat)

}
