% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/growth_transition_functions-class.R
\name{modified_transition}
\alias{modified_transition}
\title{Spatially-explicit transition function}
\usage{
modified_transition(survival_layer = NULL, fecundity_layer = NULL)
}
\arguments{
\item{survival_layer}{the name of a spatial layer in the landscape object used to modify survival values (i.e. non-zero values in rows other than the first).}

\item{fecundity_layer}{the name of a spatial layer in the landscape object used to modify fecundity values (i.e. non-zero values in the first row).}
}
\value{
An object of class \code{transition_function}
}
\description{
In the built-in \code{modified_transition function}, the values of fecundity and survival
in local cell-based transition matrices are multiplied by values in the named spatial objects
for each cell. The spatial objects can be rasters that are stored in the landscape object.
}
\details{
The behaviour of the function is to modify any non-zero values in the first row by
the "fecundity_layer" and non-zero values in rows other than the first by the "survival_layer".
This is irrespective of the type of matrix or any assumptions made by the user in creating
the transition matrix. For example, if the transition matrix values include both the
probabilities of surviving AND growing into the next stage, these can NOT be modified
individually. This operation would require the use of a custom function - see the "Creating
custom *steps* functions" vignette for more information.

Note, this function will not work if two-sex transition matrices are specified in a simulation.
This function can be modified, however, to accommodate two-sex models - review the
population_change function and see the "Creating custom *steps* functions" vignette for more
information.
}
\examples{

# Vital rates (survival and fecundity) modified based on habitat suitability.

\dontrun{
mod_fun <- modified_transition(survival_layer = "suitability", fecundity_layer = "suitability")

ls <- landscape(population = egk_pop, suitability = egk_hab, carrying_capacity = NULL)

pd <- population_dynamics(change = growth(egk_mat, transition_function = mod_fun))

simulation(landscape = ls, population_dynamics = pd, habitat_dynamics = NULL, timesteps = 20)
}
}
