% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/plot_glm.R
\name{plot.spmodel}
\alias{plot.spmodel}
\alias{plot.splm}
\alias{plot.spautor}
\alias{plot.spglm}
\alias{plot.spgautor}
\title{Plot fitted model diagnostics}
\usage{
\method{plot}{splm}(x, which, ...)

\method{plot}{spautor}(x, which, ...)

\method{plot}{spglm}(x, which, ...)

\method{plot}{spgautor}(x, which, ...)
}
\arguments{
\item{x}{A fitted model object from \code{\link[=splm]{splm()}}, \code{\link[=spautor]{spautor()}}, \code{\link[=spglm]{spglm()}}, or \code{\link[=spgautor]{spgautor()}}.}

\item{which}{An integer vector taking on values between 1 and 7, which indicates
the plots to return. Available plots are described in Details. If \code{which}
has length greater than one, additional plots are stepped through in order
using \code{<Return>}. The default for \code{\link[=splm]{splm()}} and \code{\link[=spglm]{spglm()}} fitted model objects is
\code{which = c(1, 2, 7)}. The default for \code{\link[=spautor]{spautor()}} and \code{\link[=spgautor]{spgautor()}} fitted model objects
is \code{which = c(1, 2)}.}

\item{...}{Other arguments passed to other methods.}
}
\value{
No return value. Function called for plotting side effects.
}
\description{
Plot fitted model diagnostics such as residuals vs fitted values,
quantile-quantile, scale-location, Cook's distance, residuals vs leverage,
Cook's distance vs leverage, a fitted spatial covariance function, and a
fitted anisotropic level curve of equal correlation.
}
\details{
For all fitted model objects,, the values of \code{which} make the
corresponding plot:
\itemize{
\item 1: Standardized residuals vs fitted values (of the response)
\item 2: Normal quantile-quantile plot of standardized residuals
\item 3: Scale-location plot of standardized residuals
\item 4: Cook's distance
\item 5: Standardized residuals vs leverage
\item 6: Cook's distance vs leverage
}
For \code{\link[=splm]{splm()}} and \code{\link[=spglm]{spglm()}} fitted model objects, there are two additional values of \code{which}:
\itemize{
\item 7: Fitted spatial covariance function vs distance
\item 8: Fitted anisotropic (or isotropic) level curve of equal correlation
}
}
\examples{
spmod <- splm(z ~ water + tarp,
  data = caribou,
  spcov_type = "exponential", xcoord = x, ycoord = y
)
plot(spmod)
plot(spmod, which = c(1, 2, 4, 6))
}
