% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq.R
\name{freq}
\alias{freq}
\title{Frequency Table}
\usage{
freq(
  data,
  x = NULL,
  weights = NULL,
  digits = 1,
  cum = FALSE,
  total = TRUE,
  exclude = NULL,
  sort = "",
  valid = TRUE,
  na_val = NULL,
  rescale_weights = FALSE,
  info = TRUE,
  labelled_levels = c("prefixed", "labels", "values"),
  styled = TRUE,
  show_empty_levels = FALSE,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame}, vector or factor. If a \code{data.frame} is provided, the target variable \code{x} must be specified.
Matrices are not supported; please extract a column or convert to a vector or tibble before use.}

\item{x}{A dataframe variable.}

\item{weights}{A numeric vector of weights. Must be the same length as \code{x}.}

\item{digits}{Numeric. Number of digits to be displayed for percentages. Default is \code{1}. For N, 2 digits are displayed if there is a weight variable with non-integer weights or if rescale_weight = T, otherwise 0.}

\item{cum}{Logical. If \code{FALSE} (the default), do not display cumulative percentages. If \code{TRUE}, display cumulative percentages.}

\item{total}{Logical. If \code{TRUE} (the default), add a final row of totals. If \code{FALSE}, remove a final row of totals.}

\item{exclude}{Values to exclude (e.g., \code{NA}, "Other"). Default is \code{NULL}.}

\item{sort}{Sorting method for values:
\itemize{
\item \code{""} (default): No specific sorting.
\item \code{"+"}: Sort by increasing frequency.
\item \code{"-"}: Sort by decreasing frequency.
\item \code{"name+"}: Sort alphabetically (A-Z).
\item \code{"name-"}: Sort alphabetically (Z-A).
}}

\item{valid}{Logical. If \code{TRUE} (the default), display valid percentages (excluding missing values). If \code{FALSE}, do not display valid percentages.}

\item{na_val}{Character or numeric. For factors, character or numeric vectors, values to be treated as \code{NA}.}

\item{rescale_weights}{Logical. If \code{FALSE} (the default), do not rescale weights. If \code{TRUE}, the total count will be the same as the unweighted \code{x}.}

\item{info}{Logical. If \code{TRUE} (the default), print a title and a note (label and class of \code{x}, variable weight, dataframe name) information about the model (model formula, number of observations, residual standard deviation and more).}

\item{labelled_levels}{For \code{labelled} variables, controls how values are displayed using \code{labelled::to_factor(levels = "prefixed")}:
\itemize{
\item \code{"prefixed"} or \code{"p"} (default): Show labels as \verb{[value] label}
\item \code{"labels"} or \code{"l"}: Show only the label
\item \code{"values"} or \code{"v"}: Show only the underlying value
}}

\item{styled}{Logical. If \code{TRUE} (default), formats the output using \code{print.spicy()},
which aligns columns dynamically in a structured three-line table. If \code{FALSE}, returns a standard \code{data.frame}
without formatting.}

\item{show_empty_levels}{Logical. If \code{FALSE} (default), factor levels with \code{N = 0} are removed from the output. Set to \code{TRUE} to retain all levels, even those with no observations.}

\item{...}{Additional arguments passed to \code{print.spicy()}, such as \code{show_all = TRUE}}
}
\value{
A formatted \code{data.frame} containing unique values of \code{x}, their frequencies (\code{N}), percentages (\verb{\%}), percentages of valid values (\verb{Valid\%}), with a "Total" row.
\itemize{
\item If \code{cum = TRUE}, cumulative frequencies (\verb{\%cum} and \verb{Valid\%cum}) are included.
}
}
\description{
\code{freq()} creates a frequency table for a variable or vector, with options for weighting, sorting, handling missing values, and calculating percentages.
}
\examples{
data(iris)
data(mtcars)
freq(iris, Species)
iris |> freq(Species, cum = TRUE)
freq(mtcars, cyl, sort = "-", cum = TRUE)
freq(mtcars, gear, weights = mpg, rescale_weights = TRUE)

# With labelled variable
library(labelled)
df <- data.frame(
  var1 = set_variable_labels(1:5, label = "Numeric Variable with Label"),
  var2 = labelled(1:5, c("Low" = 1, "Medium" = 2, "High" = 3)),
  var3 = set_variable_labels(
    labelled(1:5, c("Bad" = 1, "Average" = 2, "Good" = 3)),
    label = "Labelled Variable with Label"
  )
)
df |> freq(var2)
df |> freq(var2, labelled_levels = "l")
df |> freq(var2, labelled_levels = "v")
df |> freq(var3)
df |> freq(var3, labelled_levels = "v")
df |> freq(var3, labelled_levels = "l")
}
