% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pulse_sequences.R
\name{seq_steam_ideal_cof}
\alias{seq_steam_ideal_cof}
\title{STEAM sequence with ideal pulses and coherence order filtering to simulate
gradient crushers.}
\usage{
seq_steam_ideal_cof(spin_params, ft, ref, TE = 0.03, TM = 0.02, amp_scale = 2)
}
\arguments{
\item{spin_params}{spin system definition.}

\item{ft}{transmitter frequency in Hz.}

\item{ref}{reference value for ppm scale.}

\item{TE}{sequence parameter in seconds.}

\item{TM}{sequence parameter in seconds.}

\item{amp_scale}{amplitude scaling factor. Set to 2 (default) to ensure
correct scaling for water reference scaling. Set to 1 to maintain the
inherent loss of signal associated with STEAM.}
}
\value{
list of resonance amplitudes and frequencies.
}
\description{
See Landheer et al NMR Biomed 2021 34(5):e4129 and Landheer et al MRM 2019
Apr;81(4):2209-2222 for more details on the coherence order filtering method.
}
