% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitsimts.R
\name{predict.fitsimts}
\alias{predict.fitsimts}
\title{Time Series Prediction}
\usage{
\method{predict}{fitsimts}(
  object,
  n.ahead = 10,
  show_last = 100,
  level = NULL,
  xlab = NULL,
  ylab = NULL,
  main = NULL,
  plot = TRUE,
  ...
)
}
\arguments{
\item{object}{A \code{fitsimts} object obtained from \code{estimate} function.}

\item{n.ahead}{An \code{integer} indicating number of units of time ahead for which to make forecasts.}

\item{show_last}{A \code{integer} indicating the number of last observations to show in the forecast plot.}

\item{level}{A \code{double} or \code{vector} indicating confidence level of prediction interval.
By default, it uses the levels of 0.50 and 0.95.}

\item{xlab}{A \code{string} for the title of x axis.}

\item{ylab}{A \code{string} for the title of y axis.}

\item{main}{A \code{string} for the over all title of the plot.}

\item{plot}{A \code{logical} value. logical. If \code{TRUE}(the default) the predictions are plotted.}

\item{...}{Additional arguments.}
}
\description{
This function plots the time series forecast.
}
\examples{
Xt = gen_gts(300, AR(phi = c(0, 0, 0.8), sigma2 = 1))
model = estimate(AR(3), Xt)
predict(model)
predict(model, level = 0.95)

x = gts(as.vector(lynx), start = 1821, end = 1934, freq = 1, 
unit_ts = bquote(paste(10^8," ",m^3)), name_ts = "Numbers", 
unit_time = "year", data_name = "Annual Numbers of Lynx Trappings")
model = estimate(AR(1), x)
predict(model, n.ahead = 20)
predict(model, n.ahead = 20, level = 0.95)
predict(model, n.ahead = 20, level = c(0.50, 0.80, 0.95))

}
\author{
Stéphane Guerrier and Yuming Zhang
}
