% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_data.R
\name{genDummy}
\alias{genDummy}
\title{Create dummy variables from a factor or integer variable}
\usage{
genDummy(dtName, varname, sep = ".", replace = FALSE)
}
\arguments{
\item{dtName}{Data table with column}

\item{varname}{Name of factor}

\item{sep}{Character to be used in creating new name for dummy fields.
Valid characters include all letters and "_". Will default to ".". If
an invalid character is provided, it will be replaced by default.}

\item{replace}{If replace is set to TRUE (defaults to FALSE) the field
referenced varname will be removed.}
}
\description{
Create dummy variables from a factor or integer variable
}
\examples{

# First example:

def <- defData(varname = "cat", formula = ".2;.3;.5", dist = "categorical")
def <- defData(def, varname = "x", formula = 5, variance = 2)

dx <- genData(200, def)
dx

dx <- genFactor(dx, "cat", labels = c("one", "two", "three"), replace = TRUE)
dx <- genDummy(dx, varname = "fcat", sep = "_")

dx

# Second example:

dx <- genData(15)
dx <- trtAssign(dtName = dx, 3, grpName = "arm")
dx <- genDummy(dx, varname = "arm")
dx
}
\concept{generate_data}
