% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launch_shinystan.R
\name{launch_shinystan}
\alias{launch_shinystan}
\alias{launch_shinystan.default}
\alias{launch_shinystan.shinystan}
\title{Launch the 'ShinyStan' app}
\usage{
launch_shinystan(object, ...)

\method{launch_shinystan}{default}(object, ..., rstudio = getOption("shinystan.rstudio"))

\method{launch_shinystan}{shinystan}(object, ..., rstudio = getOption("shinystan.rstudio"))
}
\arguments{
\item{object}{The object to use. For the default method this can be an object
of class \code{"shinystan"}, \code{"stanfit"}, or \code{"stanreg"}. To use
other types of objects first create a shinystan object using
\code{\link{as.shinystan}}.}

\item{...}{Optional arguments passed to \code{\link[shiny]{runApp}}.}

\item{rstudio}{Only relevant for 'RStudio' users. The default (\code{FALSE})
is to launch the app in the user's default web browser rather than the 
pop-up Viewer provided by 'RStudio'. Users can change the default to
\code{TRUE} by setting the global option \code{options(shinystan.rstudio =
TRUE)}.}
}
\value{
The \code{launch_shinystan} function is used for the side effect of 
  starting the 'ShinyStan' app, but it also returns a \code{shinystan}
  object, an instance of S4 class \code{"shinystan"}.
}
\description{
Launch the 'ShinyStan' app in the default web browser. 'RStudio' users also
have the option of launching the app in the pop-up Viewer.
}
\examples{
\dontrun{
#######################################
# Example 1: 'sso' is a shinystan object
#######################################

# Just launch shinystan
launch_shinystan(sso)

# Launch shinystan and replace sso with an updated version of itself
# if any changes are made to sso while using the app
sso <- launch_shinystan(sso)

# Launch shinystan but save any changes made to sso while running the app
# in a new shinystan object sso2. sso will remained unchanged. 
sso2 <- launch_shinystan(sso) 

#######################################
# Example 2: 'sf' is a stanfit object
#######################################

# Just launch shinystan
launch_shinystan(sf)

# Launch shinystan and save the resulting shinystan object
sf_sso <- launch_shinystan(sf)

# Now sf_sso is a shinystan object and so Example 1 (above) applies when
# using sf_sso. 

#######################################
# Example 3: 'fit' is an mcmc.list, array or list of matrices
#######################################

# First create shinystan object (see ?as.shinystan) for full details)
}

}
\references{
Muth, C., Oravecz, Z., and Gabry, J. (2018)
User-friendly Bayesian regression modeling: A tutorial with rstanarm and shinystan.
\emph{The Quantitative Methods for Psychology}. 14(2), 99--119.
\url{https://www.tqmp.org/RegularArticles/vol14-2/p099/p099.pdf}

Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and
  Gelman, A. (2019), Visualization in Bayesian workflow.
  *J. R. Stat. Soc. A*, 182: 389-402. doi:10.1111/rssa.12378
  ([journal version](https://rss.onlinelibrary.wiley.com/doi/full/10.1111/rssa.12378),
   [preprint arXiv:1709.01449](https://arxiv.org/abs/1709.01449),
   [code on GitHub](https://github.com/jgabry/bayes-vis-paper))
}
\seealso{
\code{\link{as.shinystan}} for creating \code{shinystan} objects.

\code{\link{update_sso}} to update a \code{shinystan} object created
  by a previous version of the package.

\code{\link{launch_shinystan_demo}} to try a demo.
}
