% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survglg.R
\name{survglg}
\alias{survglg}
\title{Fitting linear generalized log-gamma regression models under the presence of right censored data.}
\usage{
survglg(formula, data, shape, Maxiter, Tolerance)
}
\arguments{
\item{formula}{a symbolic description of the systematic component of the model to be fitted. See details for further information.}

\item{data}{an optional data frame, list containing the variables in the model.}

\item{shape}{an optional value for the shape parameter of the model.}

\item{Maxiter}{an optional positive integer giving the maximal number of iterations for the estimating process. Default value is 1e03.}

\item{Tolerance}{an optional positive value, which represents the convergence criterion. Default value is 1e-04.}
}
\value{
mu a vector of parameter estimates asociated with the location parameter.

sigma estimate of the scale parameter associated with the model.

lambda estimate of the shape parameter associated with the model.

interval estimate of a 95\% confidence interval for each estimate parameters associated with the model.

Deviance the deviance associated with the model.
}
\description{
\code{survglg} is used to fit a multiple linear regression model in which the response variable is continuous, strictly positive, asymmetric and there are right censored observations.
In this setup, the location parameter of the logarithm of the response variable is modeled by a linear model of the parameters.
}
\examples{
require(survival)
rows  <- 240
columns <- 2
t_beta  <- c(0.5, 2)
t_sigma <- 1
set.seed(8142031)
x1 <- rbinom(rows, 1, 0.5)
x2 <- runif(columns, 0, 1)
X <- cbind(x1,x2)
s         <- t_sigma^2
a         <- 1/s
t_ini1    <- exp(X \%*\% t_beta) * rgamma(rows, scale = s, shape = a)
cens.time <- rweibull(rows, 0.3, 14)
delta1     <- ifelse(t_ini1 > cens.time, 1, 0)
obst1 <- t_ini1
for (i in 1:rows) {
if (delta1[i] == 1) {
   obst1[i] <- cens.time[i]
  }
}
data.example <- data.frame(obst1,delta1,X)
fit3 <- survglg(Surv(log(obst1),delta1) ~ x1 + x2 - 1, data=data.example,shape=0.9)
logLik(fit3)
summary(fit3)
}
\references{
Carlos A. Cardozo, G. Paula and L. Vanegas. Semi-parametric accelerated failure time models with generalized log-gamma erros. In preparation.

Cardozo C.A.,  Paula G., and Vanegas L. (2022). Generalized log-gamma additive partial linear models with P-spline smoothing. Statistical Papers.
}
\author{
Carlos Alberto Cardozo Delgado <cardozorpackages@gmail.com>
}
