% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfcr_scenario.R
\name{sfcr_scenario}
\alias{sfcr_scenario}
\title{Add scenarios to a \code{sfcr} model.}
\usage{
sfcr_scenario(
  baseline,
  scenario,
  periods,
  max_iter = 350,
  tol = 1e-10,
  method = "Broyden",
  ...
)
}
\arguments{
\item{baseline}{A model generated with the \code{sfcr_baseline()} function.}

\item{scenario}{Either a shock created with \code{sfcr_shock()}, a list of shocks,
or \code{NULL}. If \code{scenario = NULL}, the model will just extend the baseline
model.}

\item{periods}{A number specifying the total number of periods of the model to be simulated.}

\item{max_iter}{Maximum iterations allowed per period.}

\item{tol}{Tolerance accepted to determine convergence.}

\item{method}{The method to use to find a solution. Defaults to "Broyden".}

\item{...}{Extra arguments to pass to \code{rootSolve::multiroot()} function if "Newton" method
is selected.}
}
\description{
Add scenarios to a \code{sfcr} model.
}
\details{
Add scenario(s) to a model generated with \code{sfcr_baseline()} functions.

This function inherits the block structure from the steady state model. See
\code{\link{sfcr_baseline}} for further details on the algorithms.
}
\examples{
eqs <- sfcr_set(
  TX_s ~ TX_d,
  YD ~ W * N_s - TX_s,
  C_d ~ alpha1 * YD + alpha2 * H_h[-1],
  H_h ~ YD - C_d + H_h[-1],
  N_s ~ N_d,
  N_d ~ Y / W,
  C_s ~ C_d,
  G_s ~ G_d,
  Y ~ C_s + G_s,
  TX_d ~ theta * W * N_s,
  H_s ~ G_d - TX_d + H_s[-1]
)

external <- sfcr_set(G_d ~ 20, W ~ 1, alpha1 ~ 0.6, alpha2 ~ 0.4, theta ~ 0.2)

# t is set to 10 to run faster. A usual model should run at least 50 periods to find a steady state
steady_state <- sfcr_baseline(eqs, external, periods = 10)

# Increase G_d from 20 to 30 between periods 5 and 10
shock1 <- sfcr_shock(sfcr_set(G_d ~ 30), 5, 10)

sfcr_scenario(steady_state, scenario = list(shock1), 10)

# Increase W to 2, alpha2 to 0.5, and decrease theta to 0.15
shock2 <- sfcr_shock(
  variables = sfcr_set(
  W ~ 2,
  alpha2 ~ 0.5,
  theta ~ 0.15
  ),
  start = 5,
  end = 10)

sfcr_scenario(steady_state, list(shock2), 10)


}
\seealso{
\code{\link{sfcr_baseline}}
}
\author{
João Macalós, \email{joaomacalos@gmail.com}
}
