% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_dev.r
\name{f_dev0}
\alias{f_dev0}
\title{Calculate negative log-likelihood (deviance)
for one antigen:isotype pair and one incidence rate}
\usage{
f_dev0(lambda, csdata, lnpars, cond)
}
\arguments{
\item{lambda}{\code{\link[=numeric]{numeric()}} incidence parameter,
in events per person-year}

\item{csdata}{cross-sectional sample data containing variables \code{value} and \code{age}}

\item{lnpars}{longitudinal antibody decay model parameters \code{alpha}, \code{y1}, and \code{d}}

\item{cond}{measurement noise parameters \code{nu}, \code{eps}, \code{y.low}, and \code{y.high}}
}
\value{
a \code{\link[=numeric]{numeric()}} negative log-likelihood,
corresponding to input \code{lambda}
}
\description{
Calculate negative log-likelihood (deviance)
for one antigen:isotype pair and one incidence rate
}
\details{
interface with C lib \code{serocalc.so}
}
\examples{
\donttest{
library(dplyr)
library(tibble)

# load in longitudinal parameters
curve_params <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

# load in pop data
xs_data <-
  sees_pop_data_pk_100

#Load noise params
noise_params <- tibble(
  antigen_iso = c("HlyE_IgG", "HlyE_IgA"),
  nu = c(0.5, 0.5),                          # Biologic noise (nu)
  eps = c(0, 0),                             # M noise (eps)
  y.low = c(1, 1),                           # low cutoff (llod)
  y.high = c(5e6, 5e6))                      # high cutoff (y.high)

cur_antibody = "HlyE_IgA"

cur_data <-
  xs_data \%>\%
  dplyr::filter(
   .data$antigen_iso == cur_antibody) \%>\%
  dplyr::slice_head(n = 100)

cur_curve_params <-
  curve_params \%>\%
  dplyr::filter(.data$antigen_iso == cur_antibody) \%>\%
  dplyr::slice_head(n = 100)

cur_noise_params <-
  noise_params \%>\%
  dplyr::filter(.data$antigen_iso == cur_antibody)

if (!is.element('d', names(cur_curve_params)))
{
  cur_curve_params <-
    cur_curve_params \%>\%
    dplyr::mutate(
      alpha = .data$alpha * 365.25,
      d = .data$r - 1)
}

lambda = 0.1
f_dev0(
    lambda = lambda,
    csdata = cur_data,
    lnpars = cur_curve_params,
    cond = cur_noise_params
  )
}
}
\keyword{internal}
