% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R, R/sephora-methods.R
\name{plot.sephora}
\alias{plot.sephora}
\alias{sephora-methods}
\title{Plot methods for \code{sephora}}
\usage{
\method{plot}{sephora}(
  x,
  y,
  startYear,
  endYear,
  frequency,
  type = NULL,
  sizeLine = 1,
  sizePoint = 2,
  position_legend = "none",
  title_legend = NULL,
  xLab = "Time",
  yLab = "Index",
  xLim,
  msTitle = "Cluster",
  pointShape = 16,
  pointSize = 2,
  pointStroke = 3,
  textFontface = 2,
  textSize = 5,
  text_hjust = 0.5,
  text_vjust = -0.5,
  ...
)
}
\arguments{
\item{x}{a numeric vector or a \code{sephora} object.}

\item{y}{ignored.}

\item{startYear}{integer, time series initial year.}

\item{endYear}{integer, time series final year.}

\item{frequency}{integer giving number of observations per season.}

\item{type}{character specifying type of plot. By default, \code{NULL};
"profiles", "ms" and "derivatives" are also allowed.
See \bold{Details.}}

\item{sizeLine}{integer giving line size}

\item{sizePoint}{integer giving point size}

\item{position_legend}{character. Should a legend be added? Where? See
\code{\link[ggplot2]{theme}}.}

\item{title_legend}{character. Should a legend be added? What would it be? See
\code{\link[ggplot2]{theme}} and \bold{Details}.}

\item{xLab}{character, label to display in x-axis.}

\item{yLab}{character, label to display in y-axis. See \bold{Details}.}

\item{xLim}{date vector of length 2 indicating limits of x-axis. When no
supplied, \code{x} will be displayed in the period
of time defined by \code{startYear}, \code{endYear} and
\code{frequency}.}

\item{msTitle}{character. Default "Cluster". See \bold{Details}.}

\item{pointShape}{\code{shape} parameter used in \code{\link[ggplot2]{geom_point}}. Default 16.
See \bold{Details}.}

\item{pointSize}{\code{size} parameter used in \code{\link[ggplot2]{geom_point}}. Default 2.
See \bold{Details}.}

\item{pointStroke}{\code{stroke} parameter used in \code{\link[ggplot2]{geom_point}}. Default 3.
See \bold{Details}.}

\item{textFontface}{\code{fontface} parameter used in \code{\link[ggplot2]{geom_text}}. Default 2.
See \bold{Details}.}

\item{textSize}{\code{size} parameters used in \code{\link[ggplot2]{geom_text}}. Default 5.
See \bold{Details}.}

\item{text_hjust}{\code{hjust} parameter used in \code{\link[ggplot2]{geom_text}}. Default 0.5.
See \bold{Details}.}

\item{text_vjust}{\code{vjust} parameter used in \code{\link[ggplot2]{geom_text}}. Default -0.5.
See \bold{Details}.}

\item{...}{additional \code{\link[ggplot2]{ggplot}} parameters.}
}
\value{
A \code{gg} object (or \code{NULL} (invisible) when \code{type="derivatives"}).
}
\description{
Methods associated with \code{\link[sephora]{sephora-class}}.
}
\details{
By default, \code{type=NULL} and this option allows for plotting \code{numeric}
vectors and \code{sephora} objects; argument \code{title_legend} is only pertinent in this case.
Other allowed options for \code{type} are "profiles", "ms" and "derivatives". When 
\code{type="profiles"} all the arguments used in the default case are allowed except for
\code{title_legend}. When \code{type="ms"}, arguments \code{msTitle}, \code{pointShape},
\code{pointSize}, \code{pointStroke}, \code{textFontface}, \code{textSize}, \code{text_hjust}
and \code{text_vjust} are pertinent. When \code{type="derivatives"}, the default value of
argument \code{yLab} will be used.
}
\section{Plotting}{


This function draws either a graphic based on a \code{\link[ggplot2]{ggplot}} or a \code{\link[base]{plot}} object. 

The default is intended for \code{numeric} vectors and \code{\link[sephora]{sephora-class}} objects.
This method employs the \code{ggplot2} system and returns a sort of time series plot.

The method \emph{profiles}, selected when \code{type="profiles"}, is also intended for \code{numeric} 
vectors and \code{\link[sephora]{sephora-class}} objects. This method is based on the \code{ggplot2} system
and draws \eqn{p} curves, one for each period (\code{p=length(startYear:endYear)}), on 
the same time scale (days of the year). 

The method \emph{ms}, selected when \code{type="ms"}, is intended for \code{\link[sephora]{sephora-class}} objects
only. Using the \code{ggplot2} system this method draws the result of a multidimensional
scaling analysis performed on the smoothed version of the \eqn{p} curves described above.

The method \emph{derivative}, selected when \code{type="derivatives"}, is intended for
\code{\link[sephora]{sephora-class}} objects only. A 5-panel plot is drawn showing (from top 
to bottom):

 \itemize{
   \item FPCA estimate: the \code{fpca} entry of \code{\link[sephora]{sephora-class}} object. See \code{\link[sephora]{phenopar}}.
   
   \item First, second, third and fourht derivative of FPCA estimate: curve obtained by applying \code{\link[sephora]{ndvi_derivatives}}
   to FPCA estimate.
 }
}

