% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wald_test.R
\name{wald_test}
\alias{wald_test}
\title{Wald test for threshold spatial dynamic panel data model}
\usage{
wald_test(th_res)
}
\arguments{
\item{th_res}{msdpdth class, generated by function msdpdth()}
}
\value{
A list of p-values for each parameter.
}
\description{
Wald test for threshold spatial dynamic panel data model
}
\details{
Two sided Wald test for testing whether two estimated parameters for each group are equal
\itemize{
\item{"h_0"} {\eqn{\theta_1 = \theta_2}}
\item{"h_1"} {\eqn{\theta_1 \neq \theta_2}}
}
}
\examples{
\donttest{
data(data_th, data_w)
result <- msdpdth(y = data_th$y, x = data_th$x, w1 = data_w, th = data_th$th)
wald_test(result)
}

}
