% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emmeans.R
\name{emmeans.sdmTMB}
\alias{emmeans.sdmTMB}
\title{Estimated marginal means with the \pkg{emmeans} package with \pkg{sdmTMB}}
\description{
Methods for using the \pkg{emmeans} package with \pkg{sdmTMB}. The
\pkg{emmeans} package computes estimated marginal means for the fixed
effects.

For delta/hurdle models, you can specify which component to analyze using the
\code{model} argument: \code{model = 1} for the binomial component (encounter
probability) or \code{model = 2} for the positive component (e.g., gamma for
\code{delta_gamma()}). By default, \code{model = 1}.
}
\examples{
\dontshow{if (require("emmeans", quietly = TRUE)) withAutoprint(\{ # examplesIf}
mesh <- make_mesh(pcod_2011, c("X", "Y"), cutoff = 20)
fit <- sdmTMB(
  present ~ as.factor(year),
  data = pcod_2011, mesh = mesh,
  family = binomial()
)
fit
emmeans::emmeans(fit, ~ year)
emmeans::emmeans(fit, pairwise ~ year)
emmeans::emmeans(fit, pairwise ~ year, type = "response")
emmeans::emmeans(fit, pairwise ~ year, adjust = "none")

e <- emmeans::emmeans(fit, ~ year)
plot(e)

e <- emmeans::emmeans(fit, pairwise ~ year)
confint(e)
summary(e, infer = TRUE)
as.data.frame(e)

# interaction of factor with continuous predictor:
fit2 <- sdmTMB(
  present ~ depth_scaled * as.factor(year),
  data = pcod_2011, mesh = mesh,
  family = binomial()
)
fit2
# slopes for each level:
emmeans::emtrends(fit2, ~ year, var = "depth_scaled")
# test difference in slopes:
emmeans::emtrends(fit2, pairwise ~ year, var = "depth_scaled")
emmeans::emmip(fit2, year ~ depth_scaled,
  at = list(depth_scaled = seq(-2.5, 2.5, length.out = 50)), CIs = TRUE)

# delta/hurdle models:
fit_delta <- sdmTMB(
  density ~ as.factor(year),
  data = pcod_2011, spatial = "off",
  family = delta_gamma()
)
# binomial component (encounter probability):
emmeans::emmeans(fit_delta, ~ year, model = 1)
# positive component (gamma):
emmeans::emmeans(fit_delta, ~ year, model = 2)
\dontshow{\}) # examplesIf}
}
\references{
\url{https://aosmith.rbind.io/2019/03/25/getting-started-with-emmeans/}
}
