% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmarkdown.R
\name{tiddler_document}
\alias{tiddler_document}
\title{Format for converting from R Markdown to another tiddler markdown}
\usage{
tiddler_document(
  host = NULL,
  remote = FALSE,
  preview = FALSE,
  tags = NULL,
  fields = NULL,
  use_bookdown = FALSE,
  overwrite = FALSE,
  variant = "gfm",
  pandoc_args = "--wrap=none",
  ...
)
}
\arguments{
\item{host}{the host of tiddlywiki web server}

\item{remote}{whether put into remote TiddlyWiki Node.js Server}

\item{preview}{whether to send `open_tiddler` command to ws server (tw-livebridge) to preview in browser}

\item{tags}{tiddler tags}

\item{fields}{a named vector for tiddler fields}

\item{use_bookdown}{logical. Use bookdown to generate markdown file.}

\item{overwrite}{whether to overwrite the existing tiddler.}

\item{variant}{variant for md_document}

\item{pandoc_args}{pandoc_args for md_document}

\item{...}{Other argument pass to md_document}
}
\value{
R Markdown output format to pass to render()
}
\description{
Format for converting from R Markdown to another tiddler markdown
}
\examples{
\dontrun{
library(rmarkdown)
render("input.Rmd")
}
}
