% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_save_surveys.R
\name{subset_save_surveys}
\alias{subset_save_surveys}
\title{Subset and Save Surveys}
\usage{
subset_save_surveys(
  var_harmonization,
  selection_name = "trust",
  import_path = "",
  export_path = "working"
)
}
\arguments{
\item{var_harmonization}{Metadata of surveys, including at least
\code{filename}, \code{var_name_orig}, \code{var_name},
 \code{var_label}.}

\item{selection_name}{An identifier for the survey subset.}

\item{import_path}{The path to the survey files.}

\item{export_path}{The path where the subsets should be saved.}
}
\value{
The function does not return a value. It saves the subsetted
surveys into .rds files.
}
\description{
Read a predefined survey list and variables.
}
\examples{
\donttest{
test_survey <- read_rds (
 file = system.file("examples", "ZA7576.rds",
                    package = "retroharmonize")
)

test_metadata <- metadata_create ( test_survey )
test_metadata <- test_metadata[c(18:37),]
test_metadata$var_name  <- var_label_normalize (test_metadata$var_name_orig)
test_metadata$var_label <- test_metadata$label_orig

saveRDS(test_survey, file.path(tempdir(), 
                              "ZA7576.rds"), 
       version = 2)

subset_save_surveys  ( var_harmonization = test_metadata, 
                      selection_name = "tested",
                      import_path = tempdir(), 
                      export_path = tempdir())

file.exists ( file.path(tempdir(), "ZA7576_tested.rds"))
}
}
\seealso{
Other import functions: 
\code{\link{pull_survey}()},
\code{\link{read_dta}()},
\code{\link{read_rds}()},
\code{\link{read_spss}()},
\code{\link{read_surveys}()}
}
\concept{import functions}
