% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{ttl}
\alias{ttl}
\title{Creates a title attribute}
\usage{
ttl(
  titles,
  align = "center",
  blank_row = "below",
  borders = NULL,
  width = NULL,
  bold = FALSE,
  font_size = NULL
)
}
\arguments{
\item{titles}{A vector of title strings.}

\item{align}{The position to align the titles.  Valid values are 'left', 
'right', 'center' or 'centre'.  For titles, the default is 'center'.}

\item{blank_row}{Where to place a blank row.  Valid values are 'above',
'below', 'both', or 'none'.  Default is "below".}

\item{borders}{Whether and where to place a border. Valid values are 'top',
'bottom', 'left', 'right', 'outside', 'inside', 'all', or 'none'.  
Default is "none".}

\item{width}{The width of the titles block.}

\item{bold}{A parameter to bold the titles.  Valid values are TRUE and FALSE.
Default is FALSE.}

\item{font_size}{The font size to use for the title block.  The font size
of the report will be used by default.  Valid values are 8, 9, 10, 11, 12,
13, and 14.}
}
\value{
A title attribute object.
}
\description{
This function creates a titles attribute, which can be used to
define titles by attaching as an attribute to a data frame.  This function is 
used internally to the system.
}
\seealso{
\code{\link{titles}} function.

Other attributes: 
\code{\link{ftn}()},
\code{\link{span}()}
}
\concept{attributes}
