#' Pembrolizumab example OS KM reconstruction clicks - pembrolizumab arm
#'
#' A dataset containing the clicks used to reconstruct the pembrolizumab OS KM curve.
#'
#' @format A data frame with 97 rows and 2 variables, time (event time in months) and survival (probability of OS)
#' @docType data
#' @keywords datasets
#' @name pembro_clicks
#' @usage data(pembro_clicks)
#' @references Gandhi et al. NEJM 2018;378(22):2078-2092
NULL

#' Pembrolizumab example OS NAR table - pembrolizumab arm
#'
#' A dataset containing the number at risk information for the pembrolizumab OS KM curve.
#'
#' @format A data frame with 8 rows and 2 variables, time (time in months) and NAR (number still at risk)
#' @docType data
#' @keywords datasets
#' @name pembro_NAR
#' @usage data(pembro_NAR)
#' @references Gandhi et al. NEJM 2018;378(22):2078-2092
NULL

#' Pembrolizumab example OS KM reconstruction clicks - placebo arm
#'
#' A dataset containing the clicks used to reconstruct the placebo OS KM curve.
#'
#' @format A data frame with 96 rows and 2 variables, time (event time in months) and survival (probability of OS)
#' @docType data
#' @keywords datasets
#' @name pbo_clicks
#' @usage data(pbo_clicks)
#' @references Gandhi et al. NEJM 2018;378(22):2078-2092
NULL


#' Pembrolizumab example OS NAR table - placebo arm
#'
#' A dataset containing the number at risk information for the placebo OS KM curve.
#'
#' @format A data frame with 8 rows and 2 variables, time (time in months) and NAR (number still at risk)
#' @docType data
#' @keywords datasets
#' @name pbo_NAR
#' @usage data(pbo_NAR)
#' @references Gandhi et al. NEJM 2018;378(22):2078-2092
NULL
