% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{discretize}
\alias{discretize}
\title{Discretize}
\usage{
discretize(xx, breaks = 3, boundaries = NULL, categories = NULL, w = NULL)
}
\arguments{
\item{xx}{matrix or data.frame whose variables needs to be discretized.}

\item{breaks}{number of categories for each variable. Ignored if \code{boundaries} != \code{NULL}.}

\item{boundaries}{user-defined upper and lower limit matrix of discretization
for each variable. Default is \code{NULL}.}

\item{categories}{user-defined category names for each variable. Default is \code{NULL}.}

\item{w}{sample weights for quantile calculation.}
}
\value{
a list consists of:
 \item{x_discrete}{data.frame of discretized variables. Each variable is a factor.}
 \item{boundaries}{upper and lower limit matrix of discretization
for each variable.}
 \item{categories}{category names for each variable.}
}
\description{
Discretizes numeric variables
}
\details{
Uses quantiles for discretization. However, quantiles may be equal in some cases.
Then equal interval discretization used instead.
}
\author{
Fatih Saglam, fatih.saglam@omu.edu.tr
}
