% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psrwe_powerprior.R
\name{rwe_stan}
\alias{rwe_stan}
\title{Call STAN models}
\usage{
rwe_stan(
  lst_data,
  stan_mdl = c("powerps", "powerpsbinary", "powerp", "powerps_wattcon"),
  chains = 4,
  iter = 2000,
  warmup = 1000,
  control = list(adapt_delta = 0.95),
  ...
)
}
\arguments{
\item{lst_data}{List of study data to be passed to STAN}

\item{stan_mdl}{STAN model including
   \describe{
    \item{powerps}{PS-power prior model for continuous outcomes}
    \item{powerpsbinary}{PS-power prior model for binary outcomes}
    \item{powerp}{Power prior model}
}}

\item{chains}{STAN parameter. Number of Markov chains}

\item{iter}{STAN parameter. Number of iterations}

\item{warmup}{STAN parameter. Number of burn-in.}

\item{control}{STAN parameter. See \code{rstan::stan} for details.}

\item{...}{other options to call STAN sampling such as \code{thin},
\code{algorithm}. See \code{rstan::sampling} for details.#'}
}
\value{
Result from STAN sampling
}
\description{
Call STAN models. Called by \code{psrwe_powerp}.
}
