% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/promise.R
\name{promise}
\alias{promise}
\title{Create a new promise object}
\usage{
promise(action)
}
\arguments{
\item{action}{A function with signature \verb{function(resolve, reject)}.}
}
\value{
A promise object (see \code{\link{then}}).
}
\description{
\code{promise()} creates a new promise. A promise is a placeholder object for the
eventual result (or error) of an asynchronous operation. This function is not
generally needed to carry out asynchronous programming tasks; instead, it is
intended to be used mostly by package authors who want to write asynchronous
functions that return promises.
}
\details{
The \code{action} function should be a piece of code that returns quickly, but
initiates a potentially long-running, asynchronous task. If/when the task
successfully completes, call \code{resolve(value)} where \code{value} is the result of
the computation (like the return value). If the task fails, call
\code{reject(reason)}, where \code{reason} is either an error object, or a character
string.

It's important that asynchronous tasks kicked off from \code{action} be coded very
carefully--in particular, all errors must be caught and passed to \code{reject()}.
Failure to do so will cause those errors to be lost, at best; and the caller
of the asynchronous task will never receive a response (the asynchronous
equivalent of a function call that never returns, i.e. hangs).

The return value of \code{action} will be ignored.
}
\section{\verb{action=} formulas}{


\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

With \code{{promises}} depending on R >= 4.1, the shorthand of a formula, \code{~ fn(.)} for \code{action} is no longer recommended by the \code{{promises}} package or
tidyverse (for example,
\href{https://github.com/tidyverse/purrr/commit/670c3ed9920f15da0d4175068ecddc41f0f1f335#diff-c4dcc43795da5c7f6bf5a94d957b5507ce795fedd6d3eb092ccad03678c4f76dR15}{\code{{purrr}}})
as we now have access to the function shorthand, \verb{\\(x) fn(x)}. Please update
your \code{action} code to use the new function shorthand syntax \verb{\\(resolve, reject) resolve(arg1, arg2)} instead of \code{~ { resolve(arg1, arg2) }}. The
magically created \code{resolve}/\code{reject} functions can be confusing when chained
with other methods.
}

\examples{
# Create a promise that resolves to a random value after 2 secs
p1 <- promise(\(resolve, reject) {
  later::later(\() resolve(runif(1)), delay = 2)
})

p1 |> then(print)

# Create a promise that errors immediately
p2 <- promise(\(resolve, reject) {
  reject("An error has occurred")
})
then(p2,
  onFulfilled = \(value) message("Success"),
  onRejected = \(err) message("Failure")
)

}
