% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/date_when.R
\name{date_when}
\alias{date_when}
\title{Calculate and display date of specific pregnancy week}
\usage{
date_when(weeks, due_date = NULL, person = NULL, today = Sys.Date())
}
\arguments{
\item{weeks}{Numeric value indicating the number of weeks of pregnancy to calculate the date for.}

\item{due_date}{Date or character string representing a date, e.g. "YYYY-MM-DD".
The expected due date. If NULL, will try to use the "pregnancy.due_date" option.
Required if option not set.}

\item{person}{The person who is pregnant, to determine the grammar for the output message. Can be:
\itemize{
\item "I", "1", "1st", "first", or numeric \code{1} for first person
\item "you", "2", "2nd", "second", or numeric \code{2} for second person
\item Any other name for third person
\item \code{NULL}: will try to use the "pregnancy.person" option. Defaults to "You" if the option is set.
}}

\item{today}{Date or character string representing a date, e.g. "YYYY-MM-DD".
Represents the reference date for calculations. Default is Sys.Date().
This parameter exists primarily for testing and documentation purposes and it is unlikely to make sense for the user to need or want to change it from the default.}
}
\value{
Invisibly returns a Date object of when the specified week of pregnancy occurs/occurred/will occur.

Prints messages to the console showing:
\itemize{
\item When the specified week of pregnancy occurs/occurred/will occur
\item How far in the past/future that date is from today (unless that date is the current date)
}
}
\description{
Calculate and display date of specific pregnancy week
}
\details{
The function calculates when someone will be/was a specific number of weeks pregnant based on their due date.
It handles past, present and future dates appropriately in its messaging.
The due date can be provided directly or set globally using options("pregnancy.due_date").
Similarly, the person being referenced can be provided directly or set globally using options("pregnancy.person").

If \code{date_when} or \code{today} is a character string, the conversion to a \code{Date}
is handled by \code{anytime::anydate()}.
}
\examples{
# Set a due date
date_when(20, due_date = "2025-12-01")
date_when(33, due_date = as.Date("2025-12-01"), person = "Sarah")

}
\seealso{
\code{\link[=calculate_due_date]{calculate_due_date()}} for calculating the due date
\code{\link[=set_due_date]{set_due_date()}} for setting the due date as a global option
\code{\link[=how_far]{how_far()}} for calculating current pregnancy progress
}
