% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_translate.R
\name{google_translate}
\alias{google_translate}
\title{Translate text using Google Translate}
\usage{
google_translate(text, target_language = "en", source_language = "auto")
}
\arguments{
\item{text}{This is the text that you want to translate. Can be a single string or a vector of strings.}

\item{target_language}{This is the language that you want to translate the text into.
The default value is "en" (English).}

\item{source_language}{This is the language of the text to be translated.
The default value is "auto", which attempts automatic language detection.}
}
\value{
A translated string or vector of translated strings, matching the length of the input.
}
\description{
Translates input text to a specified language using the Google Translate mobile web interface.
Automatically detects and preserves URLs by temporarily replacing them with placeholders.
}
\examples{
\donttest{
# Translate a simple sentence
google_translate("I love languages", target_language = "es")

# Translate a vector of words
text_to_translate <- c("the", "quick", "brown")
google_translate(text_to_translate, "fr", "en")

# Translate text containing a URL
google_translate("Visit http://example.com for more info.", target_language = "de")
}
}
