% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pocket_unfavorite.R
\name{pocket_unfavorite}
\alias{pocket_unfavorite}
\title{pocket_unfavorite}
\usage{
pocket_unfavorite(
  item_ids,
  consumer_key = Sys.getenv("POCKET_CONSUMER_KEY"),
  access_token = Sys.getenv("POCKET_ACCESS_TOKEN")
)
}
\arguments{
\item{item_ids}{Character vector. Pocket item IDs you want to unfavorite. Get them, e.g., via \code{pocket_get}.}

\item{consumer_key}{character. Your Pocket consumer key. Defaults to Sys.getenv("POCKET_CONSUMER_KEY").}

\item{access_token}{character. Your Pocket request token. Defaults to Sys.getenv("POCKET_ACCESS_TOKEN").}
}
\value{
Invisibly returns a list containing information on whether the action failed or succeeded, including the respective item ID.
}
\description{
Unfavorite items from your Pocket list.
}
\details{
This function uses the \code{modify} endpoint of the Pocket API which exhibits some weird behaviour. 
For example, even if a `modify` action is not successful, the API will still return "success". 
See [issue [#26](https://github.com/CorrelAid/pocketapi/issues/26) for a discussion.
}
