% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary_trelliData.R
\name{summary-trelliData}
\alias{summary-trelliData}
\alias{summary.trelliData}
\title{Summarizes potential plotting options for a trelliData object}
\usage{
\method{summary}{trelliData}(object, ...)
}
\arguments{
\item{object}{An object from the as.trelliData.edata or as.trelliData
functions}

\item{...}{further arguments passed to or from other methods.}
}
\value{
A data.frame containing panel plot options for this trelliData object.
}
\description{
Summarizes potential plotting options for a trelliData object
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

library(dplyr)
library(pmartRdata)

trelliData <- as.trelliData.edata(e_data = pep_edata,
                                   edata_cname = "Peptide",
                                   omics_type = "pepData")

# Use an edata example. Build with as.trelliData.edata.
summary(trelliData)
summary(trelliData \%>\% trelli_panel_by("Peptide"))
summary(trelliData \%>\% trelli_panel_by("Sample"))

}
\dontshow{\}) # examplesIf}
}
