% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpa_psi.R
\name{mpa_psi}
\alias{mpa_psi}
\title{Pounds per square inch to megapascals}
\usage{
mpa_psi(x)
}
\arguments{
\item{x}{pressure (stress) measured in \emph{pounds per square inch} (\emph{PSI}).
Type: \code{\link{assert_double}}.}
}
\value{
pressure (stress) in \emph{megapascals} (\emph{MPa}).
 Type: \code{\link{assert_double}}.
}
\description{
Convert pressure (stress) measured in \href{https://en.wikipedia.org/wiki/Pounds_per_square_inch}{pounds per square inch} (PSI)
 to \href{https://en.wikipedia.org/wiki/Pascal_(unit)}{megapascals} (MPa)
}
\examples{
 library(pipenostics)

 mpa_psi(c(145.03773800721814, 1))
 # [1] 1.000000000 0.006894757 # [MPa]

}
\seealso{
\code{\link{psi_mpa}} for converting \emph{megapascals} to \emph{pounds per square inch}

Other units: 
\code{\link{c_k}()},
\code{\link{f_k}()},
\code{\link{inch_mm}()},
\code{\link{k_c}()},
\code{\link{kgf_mpa}()},
\code{\link{loss_flux}()},
\code{\link{mm_inch}()},
\code{\link{mpa_kgf}()},
\code{\link{psi_mpa}()}
}
\concept{units}
