% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_phenofit.R
\name{process_phenofit}
\alias{process_phenofit}
\title{Extract Vegetation Phenology at site scale}
\usage{
process_phenofit(
  d_obs,
  nptperyear = 36,
  south = FALSE,
  options_season = list(wFUN = "wTSM", maxExtendMonth = 12, MaxPeaksPerYear = 3,
    MaxTroughsPerYear = 4),
  options_fitting = list(methods = c("AG", "Zhang", "Beck", "Elmore", "Gu"), wFUN =
    "wTSM", maxExtendMonth = 12, minExtendMonth = 0.5, use.y0 = FALSE),
  brks = NULL,
  TRS = c(0.1, 0.2, 0.5, 0.6, 0.8, 0.9),
  run.curvefit = TRUE,
  ...
)
}
\arguments{
\item{d_obs}{data.table with the columns of y, t, w and QC_flag (optional).}

\item{nptperyear}{Integer, number of images per year.}

\item{south}{Boolean. In south hemisphere, growing year is 1 July to the
following year 31 June; In north hemisphere, growing year is 1 Jan to 31 Dec.}

\item{brks}{A list object with the elements of 'fit' and 'dt', returned by
\code{season} or \code{season_mov}, which contains the growing season division information.}

\item{...}{other parameters to \code{\link[=curvefits]{curvefits()}}}
}
\description{
Extract Vegetation Phenology at site scale
}
\keyword{internal}
