% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCODE.R
\name{outterobj_multi_missing}
\alias{outterobj_multi_missing}
\title{Outter objective function (multiple dimension version with unobserved state variables)}
\usage{
outterobj_multi_missing(ode.parameter, basis.initial, derivative.model, inner.input, NLS)
}
\arguments{
\item{ode.parameter}{Structural parameters of the ODE model.}

\item{basis.initial}{Initial values of the basis coefficients for nonlinear least square optimization.}

\item{derivative.model}{The function defines the ODE model and is the same as the ode.model in 'pcode'}

\item{inner.input}{Input that will be passed to the inner objective function. Contains dependencies for the optimization, including observations, penalty parameter lambda, and etc..}

\item{NLS}{Default is \code{TRUE} so the function returns vector of residuals, and otherwise returns sum of squared errors.}
}
\value{
\item{residual}{Vector of residuals and evaluation of penalty function on quadrature points for approximating the integral.}
}
\description{
An objective function of the structural parameter computes the measure of fit for the basis expansion.
}
