% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\name{orderly_batch}
\alias{orderly_batch}
\title{Run a batch of reports.}
\usage{
orderly_batch(name = NULL, parameters = NULL, ...)
}
\arguments{
\item{name}{Name of the report to run (see
\code{\link[=orderly_list]{orderly_list()}}).  A leading \verb{src/} will be
removed if provided, allowing easier use of autocomplete.
Alternatively, the default of \code{NULL} is useful if you have
already set the working directory to be the source directory.}

\item{parameters}{Data frame of parameters passed to report. Each row
represents a parameter set to be passed to one report run.}

\item{...}{Additional args passed to \code{\link[=orderly_run]{orderly_run()}}}
}
\value{
List of ids of newly created reports
}
\description{
Run one report multiple times with different sets of parameters.
}
\examples{

path <- orderly::orderly_example("demo")
params <- data.frame(nmin = c(0.2, 0.25))
ids <- orderly::orderly_batch("other", params, root = path)
}
\seealso{
\code{\link[=orderly_run]{orderly_run()}} for details of report running
}
